/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/

#include "stdafx.h"
#include <process.h>

#include "ThreadTools.h"

//==================================================
//
//==================================================
CTaskThread::CTaskThread(void)
{
	m_dwThreadID = 0;
	m_hThreadHandle = 0;
	m_hGateKeeper = 0;
	m_dwThreadState = DEAD;

	m_hGateKeeper = CreateEvent(
		NULL,	// default security
		TRUE,	// manually reset
		FALSE,	// start nonsignaled
		NULL	// not named
		);

	if( m_hGateKeeper )
	{
		StartThread();
	}
}

//==================================================
//
//==================================================
CTaskThread::~CTaskThread()
{
	if( m_hGateKeeper ) CloseHandle(m_hGateKeeper);
	m_dwThreadState = DEAD;
}

//==================================================
//
//==================================================
void CTaskThread::ReleaseThread(void)
{
	m_dwThreadState = RELEASED;
	SetEvent(m_hGateKeeper);
}

//==================================================
//
//==================================================
HANDLE CTaskThread::StartThread(void)
{
	// we are required to have a function with a particular signature
	// here, so we us an intermediary so we maintain our class-yness. ;)
	m_hThreadHandle =  (HANDLE)// returns threadID
		_beginthread( 
		(pFNStartAddress)TaskThread, 
		NULL, // default thread stack 
		this
		);
	return( m_hThreadHandle );
}


//==================================================
// this is the function that will be spawned
//==================================================
int __cdecl CTaskThread::TaskThread( void * _pvMyThisPointer )
{
	if( !_pvMyThisPointer ) return(-1);

	CTaskThread * pMe = (CTaskThread*)_pvMyThisPointer;

	pMe->m_dwThreadID = GetCurrentThreadId();

	DWORD dwResult = 0;
	// go to a waiting state
	pMe->m_dwThreadState = WAITING;
	while(WAIT_OBJECT_0 == WaitForSingleObject(pMe->m_hGateKeeper, INFINITE) )
	{
		// indicate that we are running
		pMe->m_dwThreadState = RUNNING;

		// call the virtual function to do the work
		dwResult = pMe->VirtualCallbackFunction();

		// go back to a waiting state
		ResetEvent(pMe->m_hGateKeeper);
		pMe->m_dwThreadState = WAITING;
	}

	pMe->m_dwThreadState = DEAD;
	return(dwResult);
}

//==================================================
//
//==================================================
DWORD CTaskThread::VirtualCallbackFunction(void)
{
	// this is the function to be over-ridden
	// could make it pure virtual...
	Sleep(1000);
	return(0);
};





